#This script file is provided to make it easier for users of the vDisk replicatiuon utility to 
#download psexec.

#This script was created by Rob Zylowski Citrix CCS with help from many folks
#It should be used as an example of how to perform PVS Disk replication.
#
#Although every effort has been made to ensure that these sample scripts work properly, 
#Citrix disclaims any responsibility for any and all liability or responsibility for any 
#damages that may result from using these scripts. 
#The sample scripts are provided to you as is, with no warranty or guarantees.
#

function Get-ScriptDirectory
{
  $Invocation = (Get-Variable MyInvocation -Scope 1).Value
  Split-Path $Invocation.MyCommand.Path
}

$ScriptSource = Get-ScriptDirectory
$PsexecPath = "$ScriptSource\PSExec.exe"
try {

       
    Write-Host "Downloading psexec ..."
    [Net.ServicePointManager]::SecurityProtocol = [System.Net.SecurityProtocolType]::Tls12
    (New-Object System.Net.WebClient).DownloadFile( 'https://live.sysinternals.com/psexec.exe' , $PsexecPath )
    if( ! ( Test-Path $PsexecPath -ErrorAction SilentlyContinue -PathType Leaf ) )
    {
        Throw "Failed to download procmon"
    }
	Write-Host "The PSexec.exe was downloaded.  Unblocking the file.."
    Unblock-File -Path $PsexecPath
	Write-Host "Checking the Authenticode signature"
    $signing = Get-AuthenticodeSignature -FilePath $PsexecPath -ErrorAction SilentlyContinue
    if( ! $signing )
    {
        Throw "Could not get signing information from `"$PsexecPath`""
    }
    if( ! $signing.Status -ne 'Valid' )
    {
        Throw "Certificate status for `"$PsexecPath`" is $($signing.Status), not `"Valid`""
    }
	else
	{
		Write-Host "The exe is signed properly"
		Write-Host "Download Successful"
	}
    if( $signing.SignerCertificate.Subject -notmatch '^CN=Microsoft Corporation,' )
    {
        Throw "`"$PsexecPath`" is not signed by Microsoft Corporation, found $($signing.SignerCertificate.Subject)"
    }
   
}
catch
{
    Write-Error "Line: $($_.InvocationInfo.ScriptLineNumber) : $_"
}

sleep 3