﻿#SetupCredSSP.ps1

#This script was created by Rob Zylowski Citrix CCS 

#This script will interrogate defined PVS master Servers to compile a list pvs servers and apply CredSSp configurations to those servers.
#
#Although every effort has been made to ensure that these sample scripts work properly, 
#Citrix disclaims any responsibility for any and all liability or responsibility for any 
#damages that may result from using these scripts. 
#The sample scripts are provided to you as is, with no warranty or guarantees.
#

#Version 4.0.0 5-20-2021


function Get-ScriptDirectory
#This gets the current directlry which we use to store the text data files
{
 $Invocation = (Get-Variable MyInvocation -Scope 1).Value
 Split-Path $Invocation.MyCommand.Path
}

Function LogLine($Color,$strLine)
{
	Write-Host -ForegroundColor $Color $strLine
	$global:StrTime = Get-Date -Format "MM-dd-yyyy-HH-mm-ss-tt"
	"$global:StrTime - $strLine " | Out-file -FilePath $global:LogFile -Encoding ASCII -Append
}



$ScriptSource = Get-ScriptDirectory

$MyComputer = $ENV:Computername

$LogFolderName = "Setup"
$LogTopFolder = "$ScriptSource\..\Logs"
If (!(Test-Path "$LogTopFolder"))
{
	mkdir "$LogTopFolder" >$null
}
$LogFolder = "$LogTopFolder\$LogFolderName"
If (!(Test-Path "$LogFolder"))
{
	mkdir "$LogFolder" >$null
}
$global:LogFile = "$LogFolder\SetupCredSSP_log.txt"

try{
    Import-Module 'C:\Program Files\Citrix\Provisioning Services console\Citrix.PVS.SnapIn.dll' -ErrorAction Stop
} catch {
    Logline Red "PVS PowerShell Snap-In Not Found" 
    exit
}

$Masters = Get-Content "$ScriptSource\..\config\masters.txt" -Encoding ASCII

foreach ($MasterServerName in $Masters)
{
	Logline Blue "======= Connecting to Master Server $MasterServerName =========="
	Set-PvsConnection -Server $MasterServerName -ErrorAction SilentlyContinue
	if (!$?)
	{
		Write-Host  "Could not connect to Server [$MasterServerName] will skip processing for this server"
		continue
	}
	$FarmInfo = Get-PvsFarm
	$FarmName = $FarmInfo.Name
	
	Logline Black "Getting Farm Servers for this Master Server [$MasterServerName] Farm: [$FarmName]"
	$MasterFarm = $FarmInfo.FarmName
	$PVSServers = Get-PvsServer 
	Foreach ($PVSServer in $PVSServers)
	{
		$ServerName = $PVSServer.Name
		Logline Black "Testing PowerShell remoting on Server [$ServerName]"
		$Test = Test-WSMan -ComputerName $ServerName
		if ($?)
		{
			Logline Green "PowerShell Remoting is enabled on Server [$ServerName]"
		}
		else
		{
			Logline Red "***Warning PowerShell Remoting is NOT ENABLED on Server [$ServerName]"
			Logline Red "Skipping CREDSSP update for server [$ServerName]"
			continue
		}
		Logline Black "Configuring CredSSP Server Role [$ServerName]"
		$Scriptblock = {Enable-WSManCredSSP -Role Server -Force}
		$return = Invoke-Command -ComputerName $ServerName -ScriptBlock $Scriptblock
		If ($?)
		{
			Logline Green "CredSSP Server Role was applied successfully on [$ServerName]"
		}
		else
		{
			Logline Red "***CredSSP Server Role FAILED on [$ServerName]"
		}
		#For the conoles machine we need to add an entry for the client role
		$Returns2 = Enable-WSManCredSSP -Role Client -DelegateComputer $ServerName -Force
		If ($?)
		{
			Logline Green "CredSSP Client Role for [$ServerName] was Successfully defined on [$MyComputer]"
		}
		else
		{
			Logline Red "CredSSP Client Role for [$ServerName] Could not be defined on [$MyComputer]"
		}
	}
	
}
Logline Blue ""
Logline Blue "==========CredSSP Cnnfiguration Update Complete=========="





