﻿function Get-ScriptDirectory
{
  $Invocation = (Get-Variable MyInvocation -Scope 1).Value
  Split-Path $Invocation.MyCommand.Path
}

$ScriptPath = Get-ScriptDirectory
$MyCredential = Get-Credential
if ($MyCredential.UserName -eq $null){exit}

$Key = New-Object Byte[] 32
[Security.Cryptography.RNGCryptoServiceProvider]::Create().GetBytes($Key)
$Key | out-file "$ScriptPath\..\Config\cred2.txt"
$MyCredential.Password | ConvertFrom-SecureString -key (get-content "$ScriptPath\..\Config\cred2.txt") | set-content "$ScriptPath\..\Config\cred2.xml"
$MyCredential.UserName | Out-File "$ScriptPath\..\Config\credacc2.txt" -Encoding ASCII
