﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
//using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using System.Text.RegularExpressions;
using System.Collections.Specialized;
using System.Runtime.InteropServices;

namespace DirectorConfig1
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
   
    
    public partial class MainWindow : Window
    {
        [DllImport("kernel32.dll")]
        static extern IntPtr GetConsoleWindow();

        [DllImport("user32.dll")]
        static extern bool ShowWindow(IntPtr hWnd, int nCmdShow);

        const int SW_HIDE = 0;
        const int SW_SHOW = 5;
        private static string err = "";
        string warning=@"Warning: Uninstall will remove all the previously saved configuration
Do you want to continue?";
        String Help = @"Usage: DirectorConfig [/site <siteName>] [/ddc <XenDesktopDDCDnsName>] [/xenapp <XenAppServerDnsName>] [/uninstall] [/upgrade] [/registerdotnet]
Example:
DirectorConfig /site Director /ddc xendesktop-ddc.mydomain.com
DirectorConfig /site Director
DirectorConfig /ddc xendesktop-ddc.mydomain.com
DirectorConfig /xenapp xenapp-server.mydomain.com
DirectorConfig /uninstall

DirectorConfig /uninstall /site Director
Warning: Uninstall will remove all the previously saved configuration.
DirectorConfig /upgrade
DirectorConfig /registerdotnet";
        private static StreamWriter myStreamWriter;
        private static String inputText = "sajal\n";
        private static StringBuilder sortOutput = null;
        public MainWindow()
        {
            String file_req = @"C:/inetpub/wwwroot/Director/images/iconDD.png";
            if (File.Exists(@file_req))
            {   //start.WorkingDirectory = exe_dir;
            }
            else
            {
                MessageBox.Show("Director not installed on this machine!\nTool will exit now.", "Error!!");
                Process.GetCurrentProcess().Kill();
                //return;

            }
            try
            {
                InitializeComponent();
            }
            catch (System.Windows.Markup.XamlParseException ex)
            {
                if (MessageBox.Show("XamlParseException occured!\n View Full Exception", "Error!!", MessageBoxButton.YesNo) == MessageBoxResult.Yes)
                {
                    MessageBox.Show(ex.ToString(), "Full Exception");
                    
                }
                Process.GetCurrentProcess().Kill();
                //Application.Current.Shutdown();
                //return;
            }
            //MessageBox.Show("Director not installed on this machine 1", "Error!!");
            var handle = GetConsoleWindow();
            ShowWindow(handle, SW_HIDE);
            RadioButtonActions.IsChecked = true;
            RadioButtonNetscaler.IsChecked = true;
            RadioButtonDirector.IsChecked = true;
           
            //RadioButtonDirector.IsChecked = false;
        }

        private void ddc_textbox1_TextChanged(object sender, TextChangedEventArgs e)
        {
            
        }


        private void Uninstall_checkbox_Checked(object sender, RoutedEventArgs e)
        {
            
            //Xenapp_textbox1.IsEnabled = false;
            Registerdotnet_checkbox.IsChecked = false;
            Upgrade_checkbox.IsChecked = false;
            EnableRA_checkbox.IsChecked = false;
        }

        private void Upgrade_checkbox_Checked(object sender, RoutedEventArgs e)
        {
           
            //Xenapp_textbox1.IsEnabled = false;
            Uninstall_checkbox.IsChecked = false;
            Registerdotnet_checkbox.IsChecked = false;
            EnableRA_checkbox.IsChecked = false;
        }

        private void Registerdotnet_checkbox_Checked(object sender, RoutedEventArgs e)
        {
            
            //Xenapp_textbox1.IsEnabled = false;
            Uninstall_checkbox.IsChecked = false;
            EnableRA_checkbox.IsChecked = false;
            Upgrade_checkbox.IsChecked = false;
        }

        private void Uninstall_checkbox_Unchecked(object sender, RoutedEventArgs e)
        {
            //ddc_textbox1.IsEnabled = true;
            //site_textbox1.IsEnabled = true;
            //Xenapp_textbox1.IsEnabled = true;
            //Registerdotnet_checkbox.IsEnabled = true;
            //Upgrade_checkbox.IsEnabled = true;
            
        }

        private void Upgrade_checkbox_Unchecked(object sender, RoutedEventArgs e)
        {
           // if (Registerdotnet_checkbox.IsChecked == true)
               // return;
            //ddc_textbox1.IsEnabled = true;
            //site_textbox1.IsEnabled = true;
            //Xenapp_textbox1.IsEnabled = true;
            //Uninstall_checkbox.IsEnabled = true;
        }

        private void Registerdotnet_checkbox_Unchecked(object sender, RoutedEventArgs e)
        {
            //if (Upgrade_checkbox.IsChecked == true)
                //return;
            //ddc_textbox1.IsEnabled = true;
            //site_textbox1.IsEnabled = true;
           // Xenapp_textbox1.IsEnabled = true;
            //Uninstall_checkbox.IsEnabled = true;
        }

        private void Help_Button_Click(object sender, RoutedEventArgs e)
        {
            
           // MessageBox.Show(Help,"Help");
            try
            {
                string param = "";
                
               
                String exe = @"C:\inetpub\wwwroot\Director\tools\DirectorConfig.exe";
                String exe_dir = @"C:\inetpub\wwwroot\Director\tools";
                if (Directory.Exists(@exe_dir))
                { }
                else
                {
                    MessageBox.Show(Help,"Help");
                    return;
                }
                string outp = string.Empty;
                    using (StreamReader reader = Read_Output1(exe, param))
                    {
                        while (!(outp += (char)reader.Read()).Contains("Invalid Parameters:")) ;
                         outp = reader.ReadToEnd();
                        //String Outp = sortOutput.ToString();
                        MessageBox.Show(outp, "Help");
                    }
        
            }
            catch (Exception exp)
            {
                MessageBox.Show(exp.Message,"Result");
            }
        
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            String file_req = @"C:/inetpub/wwwroot/Director/images/iconDD.png";
            if (File.Exists(@file_req))
            {   //start.WorkingDirectory = exe_dir;
            }
            else
            {
                MessageBox.Show("Director not installed on this machine", "Error!!");
                return;

            }
        }

        private void site_textbox1_TextChanged(object sender, TextChangedEventArgs e)
        {

        }

       /* private void Xenapp_textbox1_TextChanged(object sender, TextChangedEventArgs e)
        {

        }*/

        private void Submit_Button_Click(object sender, RoutedEventArgs e)
        {
            try
            {
                string param = Get_Parameters();
                
               
                if (err.Equals(""))
                 { }
                else
                {
                    err = err + "Do you want to continue?";
                    if (MessageBox.Show(err, "Warning!!", MessageBoxButton.YesNo) == MessageBoxResult.No)
                    {
                        Reset_All();
                        return;
                    }
                }


                string tocheck = "/uninstall";
                string tocheck1 = "Error";
                if (param.Contains(tocheck))
                {
                    //MessageBox.Show(warning, "Warning!");
                    if (MessageBox.Show(warning, "Warning!!", MessageBoxButton.YesNo) == MessageBoxResult.No)
                    {
                        Reset_All();
                        return;
                    }
                    
                }
                if (param.Contains(tocheck1))
                {
                    //MessageBox.Show(warning, "Warning!");
                    
                    //{
                        Reset_All();
                        return;
                    //}

                }
                String exe = @"C:\inetpub\wwwroot\Director\tools\DirectorConfig.exe";
                String exe_dir = @"C:\inetpub\wwwroot\Director\tools";
                if (Directory.Exists(@exe_dir))
                { }
                else
                {
                    MessageBox.Show(@"DirectorConfig.exe not found at C:\inetpub\wwwroot\Director\tools ", "Error!!");
                    return;
                }
                if (param.Contains("/confignetscaler"))
                {
                    Read_Output(exe, param);
                }
                else
                {
                    using (StreamReader reader = Read_Output1(exe, param))
                    {
                        String Outp = reader.ReadToEnd();
                        //String Outp = sortOutput.ToString();
                        MessageBox.Show(Outp, "Result");
                        Main.Title = "Director Configuration UI Tool";
                    }
                }
                
                    //String Outp = reader.ReadToEnd();
                    //String Outp = sortOutput.ToString();
               
               
                
                

            }
            catch (Exception exp)
            {
                MessageBox.Show(exp.Message,"Result");
            }
        }

        private StreamReader Read_Output1(string Executable, string param)
        {
            StreamReader reader;

            Main.Title = "Director Configuration UI Tool-Running";
            // Start the process.
            ProcessStartInfo start = new ProcessStartInfo(Executable);
            start.Arguments = param;
            start.UseShellExecute = false;
            start.RedirectStandardOutput = true;
            start.RedirectStandardInput = true;
            start.CreateNoWindow = true;
            
            //String tools_dir = Environment.GetEnvironmentVariable("TOOLS", 0);
            //MessageBox.Show(tools_dir);

            String exe_dir = @"C:\inetpub\wwwroot\Director\tools";
            if (Directory.Exists(@exe_dir))
                start.WorkingDirectory = exe_dir;
            else
            {
                MessageBox.Show(@"DirectorConfig.exe not found at C:\inetpub\wwwroot\Director\tools ","Error!!");
            }
            
            String inputText;
            
            

            using (Process process = Process.Start(start))
            {
               
                StreamWriter myStreamWriter = process.StandardInput;
               
                   
                process.WaitForExit();
               // MessageBox.Show("abcd2");
                reader = process.StandardOutput;
                //process.WaitForInputIdle();
            }
            
            return reader;
            //throw new NotImplementedException();
        }

        private void Read_Output(string Executable, string param)
        {
            StreamReader reader;
            Process myProcess = new Process();
            Main.Title = "Director Configuration UI Tool-Running";
            Console.Clear();
            var handle = GetConsoleWindow();
            ShowWindow(handle, SW_SHOW);
            myProcess.StartInfo.FileName = Executable;
            myProcess.StartInfo.UseShellExecute = false;
            myProcess.StartInfo.RedirectStandardInput = false;
            myProcess.StartInfo.RedirectStandardOutput = false;
            myProcess.StartInfo.RedirectStandardError = false;
            myProcess.StartInfo.Arguments = param;
            myProcess.StartInfo.CreateNoWindow = false;
            Console.Clear();
            
           

            String exe_dir = @"C:\inetpub\wwwroot\Director\tools";
            if (Directory.Exists(@exe_dir))
                myProcess.StartInfo.WorkingDirectory = exe_dir;
            else
            {
                MessageBox.Show("DirectorConfig.exe not found", "Error!!");
            }
            
            inputText="sajal\n";

            myProcess.Start();
            
            myProcess.WaitForExit();
            MessageBox.Show("Done","Result");
            myProcess.Close();
            ShowWindow(handle, SW_HIDE);
            Main.Title = "Director Configuration UI Tool";
            //return reader;
        }

        private static void WriteOutput(object sendingProcess,
            DataReceivedEventArgs outLine)
        {
            if (!String.IsNullOrEmpty(outLine.Data))
            {
                // Add the text to the collected output.
                if (outLine.Data.Contains("Enter Machine"))
                {
                    //MessageBox.Show("enter machine");
                    myStreamWriter.WriteLine(inputText);
                    sortOutput.Append(Environment.NewLine + outLine.Data + inputText);
                }
                else if (outLine.Data.Contains("Enter User"))
                {
                    
                        MessageBox.Show("enter user");
                        myStreamWriter.WriteLine(inputText);
                        sortOutput.Append(Environment.NewLine + outLine.Data + inputText);
                    
                }
                else if (outLine.Data.Contains("Enter Password"))
                {
                    MessageBox.Show("enter password");
                    myStreamWriter.WriteLine(inputText);
                    sortOutput.Append(Environment.NewLine + outLine.Data + inputText);
                }
                else
                {
                    sortOutput.Append(Environment.NewLine + outLine.Data);
                }
                
                
            }
        }

        private string Get_Parameters()
        {
            //return /ddc+ddc_textbox1.Text;
            //throw new NotImplementedException();
            //ddc_textox1
            //string ddc_param=ddc_textbox1.
            string param = ""; err = "";
            if ((ddc_textbox1.IsEnabled == true) && !(string.IsNullOrEmpty(ddc_textbox1.Text.Trim())) && ddc_textbox1.Opacity == 1)
            {
                //\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\b
                string p1 = ddc_textbox1.Text.Trim();

                if ((Regex.IsMatch(p1, @"^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(,(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))*$")) || Regex.IsMatch(p1, @"^((?!\d+\.)[^\s\/]+\.)([^\s\/]+)(,((?!\d+\.)[^\s\/]+\.)([^\s\/]+))*$") || Regex.IsMatch(p1,@"localhost"))
                {
                    param += "/ddc " + ddc_textbox1.Text.Trim();
                }
                else
                {
                    //MessageBox.Show("Enter valid DDC IP or DDC Name", "Error");
                    err = @"-DDC IP or Name does not appear to be in correct format
";
                    param += "/ddc " + ddc_textbox1.Text.Trim();
                    
                }

            }
            if ((site_textbox1.IsEnabled == true) && !(string.IsNullOrEmpty(site_textbox1.Text.Trim())) && site_textbox1.Opacity == 1)
            {
                 //param += " /site " + site_textbox1.Text.Trim();
                 string p2 = site_textbox1.Text.Trim();
                 
                 if (Regex.IsMatch(p2, @"(^([^\s\/\.\,]+))(,([^\s\/\.]+))*$"))
                 {
                     param += " /site " + site_textbox1.Text.Trim();
                 }
                 else
                 {
                     //MessageBox.Show("Enter valid DDC IP or DDC Name", "Error");
                     err += @"-SiteName does not appear to be in correct format
";
                     //param += "Error";
                     param += " /site " + site_textbox1.Text.Trim();

                 }
            }
           /* if ((Xenapp_textbox1.IsEnabled == true) && !(string.IsNullOrWhiteSpace(Xenapp_textbox1.Text)))
            {
                //param += " /xenapp " + Xenapp_textbox1.Text.Trim();
                string p3 = Xenapp_textbox1.Text.Trim();
                if ((Regex.IsMatch(p3, @"^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(,(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]))*$")) || Regex.IsMatch(p3, @"^((?!\d+\.)[^\s\/]+\.)([^\s\/]+)(,((?!\d+\.)[^\s\/]+\.)([^\s\/]+))*$"))
                
                {
                    param += " /xenapp " + Xenapp_textbox1.Text.Trim();
                }
                else
                {
                    //MessageBox.Show("Enter valid DDC IP or DDC Name", "Error");
                    err += @"-Enter valid Xenapp server name";
                    param += "Error";

                }
            }*/
            if ((Uninstall_checkbox.IsEnabled == true) && (Uninstall_checkbox.IsChecked == true))
            {
                param += " /uninstall";
             
            }
            if ((Upgrade_checkbox.IsEnabled == true) && (Upgrade_checkbox.IsChecked == true))
            {
                param += " /upgrade";
            }
            if ((Registerdotnet_checkbox.IsEnabled == true) && (Registerdotnet_checkbox.IsChecked == true))
            {
                param += " /registerdotnet";
            }
            if ((ConfigNetscaler_checkbox.IsEnabled == true) && (ConfigNetscaler_checkbox.IsChecked == true))
            {
                //param += " /uninstall";
                param += " /confignetscaler";
            }
            if ((UnConfigNetscaler_checkbox.IsEnabled == true) && (UnConfigNetscaler_checkbox.IsChecked == true))
            {
                //param += " /uninstall";
                param += " /unconfignetscaler";
            }
            if ((EnableRA_checkbox.IsEnabled == true) && (EnableRA_checkbox.IsChecked == true))
            {
                //param += " /uninstall";
                param += " /enablera";
            }
           // MessageBox.Show(param);
            if(param.Equals(""))
            {
                MessageBox.Show("No Parameters entered!!", "Error");
                param += "Error";

            }
            
            return param;
        }

        private void Reset_Button_Click(object sender, RoutedEventArgs e)
        {
            Reset_All();
           
        }

       public void Reset_All()
       {
           //ddc_textbox1.IsEnabled = true;
            ddc_textbox1.Text = "";
            //site_textbox1.IsEnabled = true;
            site_textbox1.Text = "";
            //Xenapp_textbox1.IsEnabled = true;
            //Xenapp_textbox1.Text = "";
            //Uninstall_checkbox.IsEnabled = true;
            Uninstall_checkbox.IsChecked = false;
            //Upgrade_checkbox.IsEnabled = true;
            Upgrade_checkbox.IsChecked = false;
           // Registerdotnet_checkbox.IsEnabled = true;
            Registerdotnet_checkbox.IsChecked = false;
            ConfigNetscaler_checkbox.IsChecked = false;
            UnConfigNetscaler_checkbox.IsChecked = false;
       }

       private void ConfigNetscaler_checkbox_Checked(object sender, RoutedEventArgs e)
       {
           UnConfigNetscaler_checkbox.IsChecked = false;
       }
       private void ConfigNetscaler_checkbox_Unchecked(object sender, RoutedEventArgs e)
       {

       }

       private void UnConfigNetscaler_checkbox_Checked(object sender, RoutedEventArgs e)
       {
           ConfigNetscaler_checkbox.IsChecked = false;
       }

       private void UnConfigNetscaler_checkbox_Unchecked(object sender, RoutedEventArgs e)
       {

       }

       private void EnableRA_checkbox_Checked(object sender, RoutedEventArgs e)
       {
           Uninstall_checkbox.IsChecked = false;
           Registerdotnet_checkbox.IsChecked = false;
           Upgrade_checkbox.IsChecked = false;
       }

       private void EnableRA_checkbox_Unchecked(object sender, RoutedEventArgs e)
       {

       }

      

       private void MenuItem_Click(object sender, RoutedEventArgs e)
       {
           // MessageBox.Show(Help,"Help");
           try
           {
               string param = "";


               String exe = @"C:\inetpub\wwwroot\Director\tools\DirectorConfig.exe";
               String exe_dir = @"C:\inetpub\wwwroot\Director\tools";
               if (Directory.Exists(@exe_dir))
               { }
               else
               {
                   MessageBox.Show(Help, "Help");
                   return;
               }
               string outp = string.Empty;
               using (StreamReader reader = Read_Output1(exe, param))
               {
                   while (!(outp += (char)reader.Read()).Contains("Invalid Parameters:")) ;
                   outp = reader.ReadToEnd();
                   //String Outp = sortOutput.ToString();
                   MessageBox.Show(outp, "Help");
                   Main.Title = "Director Configuration UI Tool";
               }

           }
           catch (Exception exp)
           {
               MessageBox.Show(exp.Message, "Error");
               Main.Title = "Director Configuration UI Tool";
           }
       }

       private void MenuItem_Click_1(object sender, RoutedEventArgs e)
       {
           Reset_All();
       }

       private void RadioButtonDirector_Checked(object sender, RoutedEventArgs e)
       {
           //OtherActions_checkbox.IsChecked = false;
           //ConfigureNetscaler_checkbox.IsChecked = false;
           /*BorderDirector.Visibility = System.Windows.Visibility.Visible;
           PanelDirector.Visibility = System.Windows.Visibility.Visible;*/
           ddc_textbox1.IsEnabled = true;
           ddc_textbox1.Opacity = 1;
           site_textbox1.IsEnabled = true;
           site_textbox1.Opacity = 1;
           Configure_Button.IsEnabled = true;
           Configure_Button.Opacity = 1;
           Submit_Button.IsEnabled = false;
           Submit_Button.Opacity = 0.5;
       }
       private void RadioButtonDirector_Unchecked(object sender, RoutedEventArgs e)
       {
           ddc_textbox1.IsEnabled = false;
           ddc_textbox1.Opacity = 0.5;
           site_textbox1.IsEnabled = false;
           site_textbox1.Opacity = 0.5;
           Configure_Button.IsEnabled = false;
           Configure_Button.Opacity = 0.5;
           ddc_textbox1.Text = "";
           site_textbox1.Text = "";
           //BorderDirector.Visibility = System.Windows.Visibility.Collapsed;
           //PanelDirector.Visibility = System.Windows.Visibility.Collapsed;
       }

       private void RadioButtonNetscaler_Checked(object sender, RoutedEventArgs e)
       {
           //ConfigDDC_checkbox.IsChecked = false;
           //OtherActions_checkbox.IsChecked = false;
           ConfigNetscaler_checkbox.IsEnabled = true;
           ConfigNetscaler_checkbox.Opacity = 1;
           UnConfigNetscaler_checkbox.IsEnabled = true;
           UnConfigNetscaler_checkbox.Opacity = 1;
           Submit_Button.IsEnabled = true;
          Submit_Button.Opacity = 1;
           //Submit_Button.SetValue(Grid.ColumnProperty, 2);
           //Submit_Button.SetValue(Grid.ColumnSpanProperty, 1);
           
           //Submit_Button.Margin = new Thickness(5, 5, 5, 5);
           //PanelNetscaler.Visibility = System.Windows.Visibility.Visible;
           //Submit_Button.Visibility = System.Windows.Visibility.Visible;
       }
       private void RadioButtonNetscaler_Unchecked(object sender, RoutedEventArgs e)
       {
           ConfigNetscaler_checkbox.IsEnabled = false;
           ConfigNetscaler_checkbox.Opacity = 0.5;
           ConfigNetscaler_checkbox.IsChecked = false;
           UnConfigNetscaler_checkbox.IsEnabled = false;
           UnConfigNetscaler_checkbox.Opacity = 0.5;
           UnConfigNetscaler_checkbox.IsChecked = false;
           Submit_Button.IsEnabled = false;
           Submit_Button.Opacity = 0.5;
           //PanelNetscaler.Visibility = System.Windows.Visibility.Collapsed;
           //Submit_Button.Visibility = System.Windows.Visibility.Collapsed;
       }

       private void RadioButtonActions_Checked(object sender, RoutedEventArgs e)
       {
           //ConfigDDC_checkbox.IsChecked = false;
           //ConfigureNetscaler_checkbox.IsChecked = false;
           Uninstall_checkbox.IsEnabled = true;
           Uninstall_checkbox.Opacity = 1;
           Upgrade_checkbox.IsEnabled = true;
           Upgrade_checkbox.Opacity = 1;
           Registerdotnet_checkbox.IsEnabled = true;
           Registerdotnet_checkbox.Opacity = 1;
           EnableRA_checkbox.IsEnabled = true;
           EnableRA_checkbox.Opacity = 1;
           Submit_Button.IsEnabled = true;
           Submit_Button.Opacity = 1;
           //Submit_Button.SetValue(Grid.ColumnProperty, 1);
          // Submit_Button.SetValue(Grid.ColumnSpanProperty, 1);
          // Submit_Button.Margin = new Thickness(5,5,5,5);
           //Submit_Button.SetValue(MarginProperty,5);
           //PanelActions.SetValue(Grid.ColumnSpanProperty, 2);
           //PanelActions.Visibility = System.Windows.Visibility.Visible;
          // Submit_Button.Visibility = System.Windows.Visibility.Visible;
       }
       private void RadioButtonActions_Unchecked(object sender, RoutedEventArgs e)
       {
           Uninstall_checkbox.IsEnabled = false;
           Uninstall_checkbox.Opacity = 0.5;
           Uninstall_checkbox.IsChecked = false;
           Upgrade_checkbox.IsEnabled = false;
           Upgrade_checkbox.Opacity = 0.5;
           Upgrade_checkbox.IsChecked = false;
           Registerdotnet_checkbox.IsEnabled = false;
           Registerdotnet_checkbox.Opacity = 0.5;
           Registerdotnet_checkbox.IsChecked = false;
           EnableRA_checkbox.IsEnabled = false;
           EnableRA_checkbox.Opacity = 0.5;
           EnableRA_checkbox.IsChecked = false;
           Submit_Button.IsEnabled = false;
           Submit_Button.Opacity = 0.5;
           //PanelActions.Visibility = System.Windows.Visibility.Collapsed;
           //Submit_Button.Visibility = System.Windows.Visibility.Collapsed;
       }

       private void ddc_textbox1_GotFocus(object sender, RoutedEventArgs e)
       {
           ddc_textbox1.Opacity = 1;
           site_textbox1.Opacity = 0.5;
       }
       private void site_textbox1_GotFocus(object sender, RoutedEventArgs e)
       {
           site_textbox1.Opacity = 1;
           ddc_textbox1.Opacity = 0.5;
       }

    }
}
